#include "flash.h"

//is this needed if data can be read 'natively' as const?
unsigned int readflash(unsigned int p){//read and return address p (14 bits, so return int)
    NVMADRH=p>>8;    
    NVMADRL=p;
    NVMCON1bits.NVMREGS=0;                  //reading main program memory and not config bits
    NVMCON1bits.RD=1;
    return NVMDAT;
}

void writeflash(unsigned char p){     //write page p from shadow array
    unsigned int add;
    unsigned char iflag;
    unsigned char i;
    iflag=INTCON;               //save interrupt flags
    INTCONbits.GIE=0;           //disable interrupts globally
    add=p*FLASHPAGESIZE;        //assuming pages are less than 256 and evenly divide into it
    NVMCON1bits.NVMREGS=0;       //reading main program memory and not config bits
    NVMCON1bits.FREE=0;          //write operation
    NVMCON1bits.LWLO=1;          //loading latches
    NVMCON1bits.WREN=1;          
    NVMADRH=add>>8;    
    NVMADRL=add;
    for(i=0;i<FLASHPAGESIZE;i++){
        NVMDATH=RETLW_OPCODE;     //to allow normal read of const
        NVMDATL=flashshadow[i];        
        if(i==(FLASHPAGESIZE-1)){NVMCON1bits.LWLO=0;}        //clear LWLO before last word to trigger write
        NVMCON2=0x55;
        NVMCON2=0xAA;
        NVMCON1bits.WR=1;
        NOP();
        NOP();
        NVMADRL++;
    }
    NVMCON1bits.WREN=0;            //disable writes
    INTCON=iflag;                    //enable interrupts    
}

void eraseflash(unsigned char p){   //erase page p for write
    unsigned int add;
    unsigned char iflag;
    iflag=INTCON;                   //save interrupt flags
    INTCONbits.GIE=0;               //disable interrupts globally
    NVMCON1bits.NVMREGS=0;          //main program memory and not config bits
    add=p*FLASHPAGESIZE;            //assuming pages are less than 256 and evenly divide into it
    NVMADRH=add>>8;    
    NVMADRL=add;
    NVMCON1bits.FREE=1;             //erase operation
    NVMCON1bits.WREN=1;          
    NVMCON2=0x55;
    NVMCON2=0xAA;
    NVMCON1bits.WR=1;
    NOP();
    NOP();
    NVMCON1bits.WREN=0;             //disable writes
    INTCON=iflag;                   //enable interrupts    
}
